﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace KeyConfig
{
	internal interface IKeyConfigPath
	{
		string Dictionary { get; }
		string Config { get; }
		string Debug { get; }
	}

	internal class KeyConfigPath : IKeyConfigPath
	{
		internal KeyConfigPath() : this(Application.StartupPath) { }

		internal KeyConfigPath(string dir)
		{
			Dictionary = Path.Combine(dir, "CONFIG.DAT");
			Config = Path.Combine(dir, "CONFIG.INI");
			Debug = Path.Combine(dir, "KEYCONFIG.LOG.TXT");
		}

		public string Dictionary { get; private set; }

		public string Config { get; private set; }

		public string Debug { get; private set; }
	}
}